CREATE TABLE AB18A13T00
(
	T13_ID_INVOCACION	 		NUMBER(5)  		NOT NULL ,
	T01_ID_PETICION_ENVIO		NUMBER(5)  		NOT NULL ,
	T13_ID_ENVIO_WS		 		VARCHAR2(50)  		NOT NULL ,
	T13_RESPUESTA_WS			VARCHAR2(500) 		NULL,
	T13_FECHA_RECEP_WS			DATE		 		NULL,
	T13_ESTADO_ENVIO_WS	 		VARCHAR2(50)  		NULL,
	T13_ERROR_ENVIO_WS 			VARCHAR2(50) 		NULL,
	T13_FECHA_MODIF_ENVIO_WS	DATE		  		NULL,
	T13_COD_ENVIO_WS 			VARCHAR2(50) 		NULL
)
	TABLESPACE AB18A01E00;


COMMENT ON TABLE AB18A13T00 IS 'DATOS RESPUESTA WS. Almacena los datos sobre la respuesta del WS a la petición del envío. Se registra una fila por cada invocación al servicio de publicación, tanto para el envío como para la solicitud de información.';


COMMENT ON COLUMN AB18A13T00.T13_ID_INVOCACION IS 'Identificativo del registro de la tabla.';

COMMENT ON COLUMN AB18A13T00.T01_ID_PETICION_ENVIO IS 'Identificativo de la petición de envío a la que corresponde el registro.';

COMMENT ON COLUMN AB18A13T00.T13_ID_ENVIO_WS IS 'Identificador énico del anuncio generado y devuelto por el servicio de envío a boletines.';

COMMENT ON COLUMN AB18A13T00.T13_RESPUESTA_WS IS 'DOUE: Json recibido desde eSendTool.';

COMMENT ON COLUMN AB18A13T00.T13_FECHA_RECEP_WS IS 'Fecha de recepción del anuncio generado y devuelto por el servicio de envío a boletines.';

COMMENT ON COLUMN AB18A13T00.T13_ESTADO_ENVIO_WS IS 'Estado del anuncio generado y devuelto por el servicio de envío a boletines.';

COMMENT ON COLUMN AB18A13T00.T13_ERROR_ENVIO_WS IS 'Posible error del envío del anuncio generado y devuelto por el servicio de envío a boletines.';

COMMENT ON COLUMN AB18A13T00.T13_FECHA_MODIF_ENVIO_WS IS 'Fecha de modificación del anuncio generado y devuelto por el servicio de envío a boletines.';

COMMENT ON COLUMN AB18A13T00.T13_COD_ENVIO_WS IS 'Código único del anuncio generado y devuelto por el servicio de envío a boletines.';

ALTER TABLE AB18A13T00
	ADD (CONSTRAINT  PK_AB18A13T00 PRIMARY KEY (T13_ID_INVOCACION)
	USING INDEX
  TABLESPACE AB18A02E00);
  COMMIT;

